/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef matrix_xdr_h
#define matrix_xdr_h

#include <rpc/types.h>
#include <rpc/xdr.h>

#define MATRIX_SERVER (u_long)600000042
#define MATRIX_SERVER_VERSION (u_long)1

typedef enum _MATRIX_FUNCTIONS {
	CREF = 0,
	RMHD = 1,
	WMHD = 2,
	RSHD = 3,
	WSHD = 4,
	RDAT = 5,
	WDAT = 6,
	RBLK = 7,
	WBLK = 8,
	FDEL = 9,
	RDPRDAT = 10,
	WRPRDAT = 11
} MATRIX_FUNCTIONS;

typedef struct _XMAIN_HEAD {
	char magic_number[14];
	char original_file_name[32];
	short sw_version;
	short system_type;
	short file_type;
	char serial_number[10];
	int scan_start_time;
	char isotope_code[8];
	float isotope_halflife;
	char radiopharmaceutical[32];
	float gantry_tilt;
	float gantry_rotation;
	float bed_elevation;
	float intrinsic_tilt;
	short wobble_speed;
	short transm_source_type;
	float distance_scanned;
	float transaxial_fov;
	short angular_compression;
	short coin_samp_mode;
	short axial_samp_mode;
	float calibration_factor;
	short calibration_units;
	short calibration_units_label;
	short compression_code;
	char study_name[12];
	char patient_id[16];
	char patient_name[32];
	char patient_sex[1];
	char patient_dexterity[1];
	float patient_age;
	float patient_height;
	float patient_weight;
	int patient_birth_date;
	char physician_name[32];
	char operator_name[32];
	char study_description[32];
	short acquisition_type;
	short patient_orientation;
	char facility_name[20];
	short num_planes;
	short num_frames;
	short num_gates;
	short num_bed_pos;
	float init_bed_position;
	float bed_offset[15];
	float plane_separation;
	short lwr_sctr_thres;
	short lwr_true_thres;
	short upr_true_thres;
	char user_process_code[10];
	short acquisition_mode;
	float bin_size;
	float branching_fraction;
	int dose_start_time;
	float dosage;
	float well_counter_factor;
	char data_units[32];
	short septa_state;
} XMAIN_HEAD;

typedef struct _XSCAN_SUB {
	short data_type;
	short num_dimensions;
	short num_r_elements;
	short num_angles;
	short corrections_applied;
	short num_z_elements;
	short ring_difference;
	float x_resolution;
	float y_resolution;
	float z_resolution;
	float w_resolution;
	int gate_duration;
	int r_wave_offset;
	int num_accepted_beats;
	float scale_factor;
	short scan_min;
	short scan_max;
	int prompts;
	int delayed;
	int multiples;
	int net_trues;
	float cor_singles[16];
	float uncor_singles[16];
	float tot_avg_cor;
	float tot_avg_uncor;
	int total_coin_rate;
	int frame_start_time;
	int frame_duration;
	float loss_correction_fctr;
	short phy_planes[8];
} XSCAN_SUB;

typedef struct _X3DSCAN_SUB {
	short data_type;
	short num_dimensions;
	short num_r_elements;
	short num_angles;
	short corrections_applied;
	short num_z_elements[64];
	short ring_difference;
	short storage_order;
	short axial_compression;
	float x_resolution;
	float v_resolution;
	float z_resolution;
	float w_resolution;
	int gate_duration;
	int r_wave_offset;
	int num_accepted_beats;
	float scale_factor;
	short scan_min;
	short scan_max;
	int prompts;
	int delayed;
	int multiples;
	int net_trues;
	float tot_avg_cor;
	float tot_avg_uncor;
	int total_coin_rate;
	int frame_start_time;
	int frame_duration;
	float loss_correction_fctr;
	float cor_singles[64];
	float uncor_singles[64];
} X3DSCAN_SUB;

typedef struct _XIMAGE_SUB {
	short data_type;
	short num_dimensions;
	short x_dimension;
	short y_dimension;
	short z_dimension;
	float z_offset;
	float x_offset;
	float y_offset;
	float recon_zoom;
	float scale_factor;
	short image_min;
	short image_max;
	float x_pixel_size;
	float y_pixel_size;
	float z_pixel_size;
	int frame_duration;
	int frame_start_time;
	short filter_code;
	float x_resolution;
	float y_resolution;
	float z_resolution;
	float num_r_elements;
	float num_angles;
	float z_rotation_angle;
	float decay_corr_fctr;
	int processing_code;
	int gate_duration;
	int r_wave_offset;
	int num_accepted_beats;
	float filter_cutoff_frequency;
	float filter_resolution;
	float filter_ramp_slope;
	short filter_order;
	float filter_scatter_fraction;
	float filter_scatter_slope;
	char annotation[40];
	float da_x_rotation_angle;
	float da_y_rotation_angle;
	float da_z_rotation_angle;
	float da_x_translation;
	float da_y_translation;
	float da_z_translation;
	float da_x_scale_factor;
	float da_y_scale_factor;
	float da_z_scale_factor;
	float rfilter_cutoff;
	float rfilter_resolution;
	short rfilter_code;
	short rfilter_order;
	float zfilter_cutoff;
	float zfilter_resolution;
	short zfilter_code;
	short zfilter_order;
} XIMAGE_SUB;

typedef struct _XNORM_SUB {
	short data_type;
	short num_dimensions;
	short num_r_elements;
	short num_angles;
	short num_z_elements;
	short ring_difference;
	float scale_factor;
	float norm_min;
	float norm_max;
	float fov_source_width;
	float norm_quality_factor;
	short norm_quality_factor_code;
	short storage_order;
	short span;
	short z_elements[64];
} XNORM_SUB ;

typedef struct _X3DNORM_SUB {
	short data_type;
	short num_r_elements;
	short num_transaxial_crystals;
	short num_crystal_rings;
	short crystals_per_ring;
	short num_geo_corr_planes;
	short uld;
	short lld;
	short scatter_energy;
	short norm_quality_factor_code;
	float norm_quality_factor;
	float ring_dtcor1[32];
	float ring_dtcor2[32];
	float crystal_dtcor[8];
	short span;
	short max_ring_diff;
} X3DNORM_SUB;

typedef struct _XATTEN_SUB {
	short data_type;
	short num_dimensions;
	short attenuation_type;
	short num_r_elements;
	short num_angles;
	short num_z_elements;
	short ring_difference;
	float x_resolution;
	float y_resolution;
	float z_resolution;
	float w_resolution;
	float scale_factor;
	float x_offset;
	float y_offset;
	float x_radius;
	float y_radius;
	float tilt_angle;
	float attenuation_coeff;
	float attenuation_min;
	float attenuation_max;
	float skull_thickness;
	short num_additional_atten_coeff;
	float additional_atten_coeff[8];
	float edge_finding_threshold;
	short storage_order;
	short span;
	short z_elements[64];
} XATTEN_SUB;

typedef struct _CREF_args {
	char *file_name;
	XMAIN_HEAD mhead;
	int data_size;
} CREF_args;

typedef struct _RBLK_args {
	char *filename;
	int block_number;
} RBLK_args;

typedef struct _WBLK_args {
	char *filename;
	int block_number;
	char wblk[512];
} WBLK_args;

typedef struct _RBLK_resp {
	int status;
	char rblk[512];
} RBLK_resp;

typedef struct _RMHD_resp {
	int status;
	XMAIN_HEAD xmain_head;
} RMHD_resp;

typedef struct _WMHD_args {
	char *file_name;
	XMAIN_HEAD xmain_head;
} WMHD_args;

typedef struct _RSHD_args {
	char *file_name;
	int matnum;
} RSHD_args;

typedef struct _RSHD_resp {
	int status;
	char rhdat[512];
} RSHD_resp;

typedef struct _WSHD_args {
	char *file_name;
	int matnum;
	char whdat[512];
} WSHD_args;

typedef struct _RDAT_args {
	char *file_name;
	int matnum;
} RDAT_args;

typedef struct _RDAT_resp {
	int status;
	struct {
		u_int rdat_len;
		char *rdat_val;
	} rdat;
} RDAT_resp;

typedef struct _WDAT_args {
	char *file_name;
	int matnum;
	int data_type;
	struct {
		u_int wdat_len;
		char *wdat_val;
	} wdat;
} WDAT_args;

typedef struct _RDPRDAT_args {
	char *filename;
	int byte_offset;
	int bufsize;
} RDPRDAT_args;

typedef struct _RDPRDAT_resp {
	int status;
	struct {
		u_int rdprdat_len;
		char *rdprdat_val;
	} rdprdat;
} RDPRDAT_resp;

typedef struct _WRPRDAT_args {
	char *filename;
	int byte_offset;
	struct {
		u_int wrprdat_len;
		char *wrprdat_val;
	} wrprdat;
} WRPRDAT_args;

#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
bool_t xdr_MATRIX_FUNCTIONS(XDR *xdrs, MATRIX_FUNCTIONS *objp);
bool_t xdr_XMAIN_HEAD(XDR *xdrs, XMAIN_HEAD *objp);
bool_t xdr_XSCAN_SUB(XDR *xdrs, XSCAN_SUB *objp);
bool_t xdr_X3DSCAN_SUB(XDR *xdrs, X3DSCAN_SUB *objp);
bool_t xdr_XIMAGE_SUB(XDR *xdrs, XIMAGE_SUB *objp);
bool_t xdr_XNORM_SUB(XDR *xdrs, XNORM_SUB *objp);
bool_t xdr_X3DNORM_SUB(XDR *xdrs, X3DNORM_SUB *objp);
bool_t xdr_XATTEN_SUB(XDR *xdrs, XATTEN_SUB *objp);
bool_t xdr_CREF_args(XDR *xdrs, CREF_args *objp);
bool_t xdr_RBLK_args(XDR *xdrs, RBLK_args *objp);
bool_t xdr_WBLK_args(XDR *xdrs, WBLK_args *objp);
bool_t xdr_RBLK_resp(XDR *xdrs, RBLK_resp *objp);
bool_t xdr_RMHD_resp(XDR *xdrs, RMHD_resp *objp);
bool_t xdr_WMHD_args(XDR *xdrs, WMHD_args *objp);
bool_t xdr_RSHD_args(XDR *xdrs, RSHD_args *objp);
bool_t xdr_RSHD_resp(XDR *xdrs, RSHD_resp *objp);
bool_t xdr_WSHD_args(XDR *xdrs, WSHD_args *objp);
bool_t xdr_RDAT_args(XDR *xdrs, RDAT_args *objp);
bool_t xdr_RDAT_resp(XDR *xdrs, RDAT_resp *objp);
bool_t xdr_WDAT_args(XDR *xdrs, WDAT_args *objp);
bool_t xdr_RDPRDAT_args(XDR *xdrs, RDPRDAT_args *objp);
bool_t xdr_RDPRDAT_resp(XDR *xdrs, RDPRDAT_resp *objp);
bool_t xdr_WRPRDAT_args(XDR *xdrs, WRPRDAT_args *objp);
#if defined(__cplusplus)
}
#endif
#else /* __STDC__ */
bool_t xdr_MATRIX_FUNCTIONS();
bool_t xdr_XMAIN_HEAD();
bool_t xdr_XSCAN_SUB();
bool_t xdr_X3DSCAN_SUB();
bool_t xdr_XIMAGE_SUB();
bool_t xdr_XNORM_SUB();
bool_t xdr_X3DNORM_SUB();
bool_t xdr_XATTEN_SUB();
bool_t xdr_CREF_args();
bool_t xdr_RBLK_args();
bool_t xdr_WBLK_args();
bool_t xdr_RBLK_resp();
bool_t xdr_RMHD_resp();
bool_t xdr_WMHD_args();
bool_t xdr_RSHD_args();
bool_t xdr_RSHD_resp();
bool_t xdr_WSHD_args();
bool_t xdr_RDAT_args();
bool_t xdr_RDAT_resp();
bool_t xdr_WDAT_args();
bool_t xdr_RDPRDAT_args();
bool_t xdr_RDPRDAT_resp();
bool_t xdr_WRPRDAT_args();
#endif  /* __STDC__ */
#endif  /* matrix_xdr_h */
